{ this is the propertyeditor for the buttons of TTitleBar. i hope
	it works as it is expected to (on my computers it does what it
  should do). please see CAPBAR.PAS for more details on the
  complete component }

unit CapBarEd;

interface

uses
  WinTypes,WinProcs,SysUtils,Messages,Classes,Graphics,Controls,
  Forms,Dialogs,StdCtrls,ExtCtrls,DsgnIntF,DsgnWnds,LibIntF,
  Buttons,Grids,CapBar;

type
	{ this is the form that is shown to the user when he clicks the
  	button for the button-property in the objectinspector }
  TTitleBarButtonEdit = class(TDesignWindow)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Grid_Right: TStringGrid;
    Grid_Left: TStringGrid;
    Panel4: TPanel;
    Panel5: TPanel;
    But_DelLeft: TSpeedButton;
    Panel6: TPanel;
    but_addleft: TSpeedButton;
    Panel7: TPanel;
    But_AddRight: TSpeedButton;
    Panel8: TPanel;
    But_DelRight: TSpeedButton;
    Panel9: TPanel;
    But_Up: TSpeedButton;
    Panel10: TPanel;
    But_Down: TSpeedButton;
    Panel11: TPanel;
    But_Change: TSpeedButton;
    But_Exit: TSpeedButton;
    function GetOwner: TComponent;
    function GetNewName: string;
		function GetFreeIndex: integer;
		function FindButton(Idx: integer;Align: TButAlign): TTitleButton;
    procedure SetButtonFocus(But: TTitleButton);
    procedure But_ExitClick(Sender: TObject);
    procedure But_AddClick(Sender: TObject);
    procedure But_DelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Grid_DrawCell(Sender: TObject; Col, Row: Longint;
      Rect: TRect; State: TGridDrawState);
    procedure GridSelectCell(Sender: TObject; Col, Row: Longint;
      var CanSelect: Boolean);
    procedure FormShow(Sender: TObject);
    procedure But_ChangeClick(Sender: TObject);
    procedure But_UpDownClick(Sender: TObject);
  private
  	FButName: TList;					{ the list of buttons }
    FCaller: TTitleBar;       { the calling component }
		procedure ReArrangeIndex;
    procedure GetButtons(Sender: TObject);
	public
  	property Buttons: TList read FButName write FButName;
    property Owner: TComponent read GetOwner;
  end;

	{ this is the component that handles the display of our
  	propertyeditor }
  TTitleBarButtons=class(TPropertyEditor)
    function GetAttriButes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure Edit; override;
  end;

var
  TitleBarButtonEdit: TTitleBarButtonEdit;

implementation

{$R *.DFM}

{ this procedure searches for an existing propertyeditor. this is
	important when the dialog we show is not modal. and it cannot
  be modal since we want to let the user use the objectinspector
  to change the settings of the buttons }
function Createedit: TTitleBarButtonEdit;
var
  i: integer;
begin
	Result:=nil;
  { cycle through all forms on the screen and find the right one }
  for i:=0 to Screen.FormCount-1 do
  begin
    if Screen.Forms[i] is TTitleBarButtonEdit then
    begin
      Result:=TTitleBarButtonEdit(Screen.Forms[i]);
      Break;
    end;
  end;
  if Result=nil then
  begin
  	{ if nothing is found then create it }
  	Result:=TTitleBarButtonEdit.Create(Application);
  end;
end;

{*****************************************************************
***                                                            ***
***  procedures for the propertyeditor                         ***
***                                                            ***
*****************************************************************}
{ this defines the display of the property in the objectinspector:
  paDialog show the three points that open a dialog,
  paValueList shows an arrow to choose the value from a list }
function TTitleBarButtons.GetAttributes:TPropertyAttributes;
begin
  Result:=[paDialog,paReadOnly];
end;

{ this returns the string that is shown in the objectinspector for
	the property. if this isn't overriden then the original value
  will be displayed in the objectinspector (TList, TButton or
  whatever is defined in the calling componen) }
function TTitleBarButtons.GetValue: string;
begin
	Result:='(TitleButtons)';
end;

{ this procedure is called when the user activates the property in
	the objectinspector (i.e. clicking on the three points).
  DON'T FORGET TO DESTROY THE DIALOG WHEN DONE!!!!}
procedure TTitleBarButtons.Edit;
var
	Editor: TTitleBarButtonEdit;
begin
	{ first we have to create the dialog or call an existing one }
	Editor:=CreateEdit;
  { this is the calling component (TitleBar) }
  Editor.FCaller:=TTitleBar(GetComponent(0));
  { the designer is the form that contains the component the
  	property belongs to }
  Editor.Designer:=TFormDesigner(Designer);
  { now we create the buttonlist }
  Editor.GetButtons(Self);
  { here we open the dialog. if it is a dialog that completeley
  	handles the properties of the objects then you can do a
    Editor.ShowModal;

    but don't forget to set the visibility of the form to false
    before you do so.}
  Editor.Show;
end;
{*****************************************************************
***                                                            ***
***  procedures for the dialog                                 ***
***                                                            ***
*****************************************************************}
{ this is executed when the form is shown for the first time. }
procedure TTitleBarButtonEdit.FormShow(Sender: TObject);
begin
  Grid_Left.DefaultColWidth:=Grid_Left.Width-2;
  Grid_Right.DefaultColWidth:=Grid_Right.Width-2;
  GetButtons(Self);
end;

{ we have to create a TList-object to hold the list of buttons }
procedure TTitleBarButtonEdit.FormCreate(Sender: TObject);
begin
  FButName:=TList.Create;
end;

{ and also we have to destroy it when done }
procedure TTitleBarButtonEdit.FormDestroy(Sender: TObject);
begin
	FButName.Free;
end;

{ you have to define the FormClose-event in this way. if you don't
	do it then you will get a GPF in the DCL if you leave Delphi }
procedure TTitleBarButtonEdit.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
	Action:=caFree;
end;

{ this returns the ownerform of the component. the place where we
	write our buttons to. }
function TTitleBarButtonEdit.GetOwner: TComponent;
begin
	Result:=Designer.Form;
end;

{ recalculate indices of buttons. sometimes it can happen that the
	indices of the buttons get mixed. so after getting the buttons
  and showing them in the grids all indices are calculated from
  the grids. }
procedure TTitleBarButtonEdit.ReArrangeIndex;
var
	i,j: integer;
  But: TTitleButton;
  Idx: integer;
begin
	Idx:=0;
  { set the indices for the buttons in the left grid ascending from
  	top to bottom }
	for i:=0 to Grid_Left.RowCount do
  begin
		But:=FindButton(i,baLeft);
    if But<>nil then
    begin
    	But.FIdx:=Idx;
      inc(Idx);
    end;
  end;
  Idx:=Buttons.Count-1;
  { set the indices in the right grid descending from the top to
  	the bottom }
	for i:=0 to Grid_Right.RowCount do
  begin
		But:=FindButton(i,baRight);
    if But<>nil then
    begin
    	But.FIdx:=Idx;
      dec(Idx);
    end;
  end;
end;

{ find all buttons and create a list of them }
procedure TTitleBarButtonEdit.GetButtons(Sender: TObject);
var
	i,j,k: integer;
  But: TTitleButton;
  Grid: TStringGrid;
  LCount,RCount: integer;
begin
  Buttons.Clear;
  LCount:=0;
  RCount:=0;
	for i:=0 to Owner.ComponentCount-1 do
  begin
		if (Owner.Components[i].ClassType=TTitleButton) then
  	begin
      k:=Buttons.Count;
	 		But:=TTitleButton(Owner.Components[i]);
    	Buttons.Add(But);
      case But.Alignment of
      	baLeft:  	inc(LCount);
        baRight:	inc(RCount);
      end;
      { sort using index }
	    for j:=0 to k do
 		  	if But.FIdx<TTitleButton(Buttons[j]).FIdx then
     			Buttons.Exchange(k,j);
	  end;
  end;

	{ now that the buttons are set to the corresponding grid we
  	can recalculate the indices }
  ReArrangeIndex;
  Grid_Left.RowCount:=LCount;
  Grid_Right.RowCount:=RCount;
	{ only show grids when there are buttons in it }
  Grid_Left.Visible:=LCount<>0;
 	Grid_Right.Visible:=RCount<>0;
	{ repaint the grids }
	Grid_Left.Refresh;
  Grid_Right.Refresh;
end;

{ close button pressed }
procedure TTitleBarButtonEdit.But_ExitClick(Sender: TObject);
begin
	Close;
end;

{ look for the lowest free indexvalue in buttonlist }
function TTitleBarButtonEdit.GetFreeIndex: integer;
var
	i,j: integer;
  Found: boolean;
begin
	{ if there is not index found then the lowest free index is
  	the number of the buttons }
	Result:=Buttons.Count;
  Found:=False;
	for i:=0 to Buttons.Count-1 do
  begin
  	for j:=0 to Buttons.Count-1 do
    begin
	  	if TTitleButton(Buttons[j]).FIdx=i then Found:=True;
    end;
    if not Found then
    begin
    	Result:=i;
      Break;
    end;
  end;
end;

{ get new name for component }
function TTitleBarButtonEdit.GetNewName: string;
var
	i: integer;
begin
	i:=0;
  repeat
  	inc(i);
    { the buttons are named CapBut01 and so on by default. you can
    	change this without any problem. the buttons are not identified
      with their names by titlebar }
		Result:=Format('CapBut%.2d',[i]);
	until Owner.FindComponent(Result)=nil;
end;

{ add button }
procedure TTitleBarButtonEdit.But_AddClick(Sender: TObject);
var
	But: TTitleButton;
  i: integer;
begin
	{ i only set this limit here because it makes little sense to
  	define more than 10 buttons in the titlebar. but if you want
    you can set this value higher or remove it completeley }
	if Buttons.Count=10 then
  begin
  	Showmessage('Only 10 Buttons allowed!');
    Exit;
  end;

  But:=TTitleButton.Create(Owner);
  But.Name:=GetNewName;
  But.Caption:=But.Name;
	But.FIdx:=GetFreeIndex;
  if Sender=But_AddLeft then
  	But.Alignment:=baLeft
  else
  	But.Alignment:=baRight;

  GetButtons(Self);
end;

{ delete button }
procedure TTitleBarButtonEdit.But_DelClick(Sender: TObject);
var
	But: TTitleButton;
  i: integer;
  FComponents: TComponentList;
begin
	{ only delete a button when the grid that belongs to the button
  	is focused }
  if Sender=But_DelLeft then
  begin
 		if Grid_Left.Focused then
  		But:=FindButton(Grid_Left.Selection.Top,baLeft)
    else
 	  	Exit;
  end
  else if Sender=But_DelRight then
  begin
 		if Grid_Right.Focused then
  		But:=FindButton(Grid_Right.Selection.Top,baRight)
    else
 	  	Exit;
  end
  else
  	Exit;

	{ now we can remove the button }
	But.Free;
  { the objectinspector should show the calling component }
  FComponents:=TComponentList.Create;
  FComponents.Add(FCaller);
	SetSelection(FComponents);
  Designer.Modified;

  GetButtons(Self);
end;

{ sets the focus to the given button }
procedure TTitleBarButtonEdit.SetButtonFocus(But: TTitleButton);
var
	i: integer;
  Idx: integer;
  Grid: TStringGrid;
begin
  if Buttons.Count=0 then Exit;
	Idx:=0;
  i:=0;
  while (i<Buttons.Count) and (Buttons[i]<>But) do
  begin
  	if TTitleButton(Buttons[i]).Alignment=But.Alignment then
    	inc(Idx);
    inc(i);
	end;
	{ button found - set focus }
  if Buttons[i]=But then
  begin
  	if But.Alignment=baLeft then
     	Grid:=Grid_Left
    else
    begin
    	Grid:=Grid_Right;
      Idx:=Grid.RowCount-Idx-1;
    end;

    Grid.SetFocus;
    Grid.Row:=Idx;
  end;
end;

{ returns button number IDX with alignment ALIGN,
	returns NIL if nothing found }
function TTitleBarButtonEdit.FindButton(Idx: integer;Align: TButAlign): TTitleButton;
var
	i,j: integer;
begin
	Result:=nil;
	for i:=0 to Buttons.Count-1 do
  begin
  	if Align=baLeft then j:=i
    else j:=Buttons.Count-1-i;
  	if TTitleButton(Buttons[j]).Alignment=Align then
    begin
    	dec(Idx);
      if Idx<0 then
      begin
      	Result:=TTitleButton(Buttons[j]);
        Break;
      end;
    end;
  end;
end;

{ draw a cell in a grid }
procedure TTitleBarButtonEdit.Grid_DrawCell(Sender: TObject; Col,
  Row: Longint; Rect: TRect; State: TGridDrawState);
var
	Cvs: TCanvas;
  But: TTitleButton;
  Hig,Wid: integer;
  IsSelected: boolean;
  THig,TWid: integer;
  TCol,BCol: TColor;
  S: TCapStr;
begin
	{ find the button that is placed in the cell }
  if Sender=Grid_Left then
  	But:=FindButton(Row,baLeft)
  else
  	But:=FindButton(Row,baRight);
	{ if no button is placed in the cell then we can leave here }
  if But=nil then Exit;

	Cvs:=TStringGrid(Sender).Canvas;
  IsSelected:=gdFocused in State;

  if IsSelected then
  	Cvs.Brush.Color:=clHighLight
  else
  	Cvs.Brush.Color:=TStringGrid(Sender).Color;
  Cvs.Fillrect(Rect);

  S:=But.Caption;
  case But.Alignment of
  	baLeft:		Rect.Right:=Rect.Left+But.Width;
  	baRight:	Rect.Left:=Rect.Right-But.Width;
  end;

  { now we let the calling component do the drawing of the button.
  	this guarantees that the button looks like it will look in
    the captionbar }
	But.Down:=IsSelected;
  FCaller.ShowButton(Cvs,Rect,But);
end;

{ show the selected button in the objectinspector }
procedure TTitleBarButtonEdit.GridSelectCell(Sender: TObject; Col,
  Row: Longint; var CanSelect: Boolean);
var
	FComponents: TComponentList;
  But: TTitleButton;
  i: integer;
begin
	if Sender=Grid_Left then
		But:=FindButton(Row,baLeft)
  else
  	But:=FindButton(Row,baRight);
  if But=nil then Exit;

  FComponents:=TComponentList.Create;
  FComponents.Add(But);
	SetSelection(FComponents);
  Designer.Modified;
end;

{ swap from Left to Right and vice versa }
procedure TTitleBarButtonEdit.But_ChangeClick(Sender: TObject);
var
	But: TTitleButton;
begin
  Grid_Left.Visible:=True;
  Grid_Right.Visible:=True;

	if Grid_Left.Focused then
		But:=FindButton(Grid_Left.Selection.Top,baLeft)
  else
  	But:=FindButton(Grid_Right.Selection.Top,baRight);

	if But<>nil then
  begin
  	case But.Alignment of
    	baLeft:
      begin
      	But.Alignment:=baRight;
        Grid_Right.SetFocus;
      end;
      baRight:
      begin
      	But.Alignment:=baLeft;
        Grid_Left.SetFocus;
      end;
    end;
  end;
	GetButtons(Self);
  SetButtonFocus(But);
end;

{ set button one poition up or down, depending on the calling
	object }
procedure TTitleBarButtonEdit.But_UpDownClick(Sender: TObject);
var
	But1,But2: TTitleButton;
  i: integer;
  IsUp: boolean;
begin
	if Grid_Left.Focused then
  begin
		But1:=FindButton(Grid_Left.Selection.Top,baLeft);
		if But1=nil then Exit;
    if Sender=But_Up then
    begin
		  dec(But1.FIdx);
    	IsUp:=True;
    end
    else
    begin
		  inc(But1.FIdx);
    	IsUp:=False;
    end;
  end
  else
  begin
  	But1:=FindButton(Grid_Right.Selection.Top,baRight);
		if But1=nil then Exit;
    if Sender=But_Down then
    begin
		  dec(But1.FIdx);
    	IsUp:=True;
    end
    else
    begin
		  inc(But1.FIdx);
    	IsUp:=False;
    end;
  end;

  { now we have to recalculate the indices to avoid the rearrangement
  	of the buttons by ReArrangeIndex }
	for i:=0 to Buttons.Count-1 do
  begin
		But2:=TTitleButton(Buttons[i]);
    if But2<>But1 then
    begin
	    if IsUp then
      begin
				if (But1.Alignment=baLeft) then
        begin
        	if (But2.FIdx<=But1.FIdx) then inc(But2.FIdx);
        end
				else
        begin
        	if (But2.FIdx>=But1.FIdx) then inc(But2.FIdx);
        end;
      end
      else
      begin
				if (But1.Alignment=baLeft) then
        begin
        	if (But2.FIdx>=But1.FIdx) then dec(But2.FIdx);
        end
				else
        begin
        	if (But2.FIdx<=But1.FIdx) then dec(But2.FIdx);
        end;
      end;
    end;
  end;
  GetButtons(Self);
  SetButtonFocus(But1);
end;

end.
